<?php
namespace Aura\Html\Helper;

/**
 * Test class for Metas.
 * Generated by PHPUnit on 2011-04-02 at 08:28:56.
 */
class MetasTest extends AbstractHelperTest
{
    public function test__invoke()
    {
        $metas = $this->helper;
        $actual = $metas();
        $this->assertInstanceOf('Aura\Html\Helper\Metas', $actual);

        $actual = $metas(array(
            'name' => 'foo',
            'content' => 'bar',
        ))->__toString();
        $expect = '    <meta name="foo" content="bar" />' . PHP_EOL;
        $this->assertSame($expect, $actual);
    }

    public function testAddAndGet_noPosition()
    {
        $metas = $this->helper;

        $metas->addHttp('Location', '/redirect/to/here');
        $metas->addName('foo', 'bar');

        $actual = $metas->__toString();
        $expect = '    <meta http-equiv="Location" content="/redirect/to/here" />' . PHP_EOL
                . '    <meta name="foo" content="bar" />' . PHP_EOL;

        $this->assertSame($expect, $actual);
    }

    public function testSetIndent()
    {
        $metas = $this->helper;
        $metas->setIndent('  ');
        $metas->addHttp('Location', '/redirect/to/here');
        $metas->addName('foo', 'bar');

        $actual = $metas->__toString();
        $expect = '  <meta http-equiv="Location" content="/redirect/to/here" />' . PHP_EOL
                . '  <meta name="foo" content="bar" />' . PHP_EOL;

        $this->assertSame($expect, $actual);
    }
}
